<?php
namespace src\controllers;
use src\views\ContactoView;
use src\controllers\CorreoController;
use src\controllers\MailController;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class ContactoController
{
    public $ok;
    public function __construct()
    {
        $this->ok = time();
    }
    /**
     * Mostrar listado clientes con resumenes de ordenes
     * 
     */
    public function getContacto()
    {
        //variables
        $data['titulo2'] = 'CONTACTO';

        // Crear una instancia de la vista Home y renderizar
        $view = new ContactoView();
        $renderView = $view->render($data);
        return $renderView;
    }
    public function getAcept()
    {
        // Descomprimir el archivo usando ZipArchive
        $fileUpdate = CONFIG_APP['dirUpdate'] . CONFIG_APP['appRemoteVersion'] . CONFIG_APP['fileUpdate'];
        $zip = new \ZipArchive();
        $resultado = $zip->open($fileUpdate);
        if ($resultado === TRUE) {
            // Extraer archivos en el destino
            $zip->extractTo('./');
            $zip->close();
            echo '<script>alert("ACTUALIZACION EXITOSA");</script>';
            if (file_exists($fileUpdate)) {
                unlink($fileUpdate);
            }
            header('Location: /');
            exit();
        } else {
            echo '<script>alert("ERROR ACTUALIZACION ");</script>';
          //  header('Location: /');
            exit();
        }
    }
    public function correo()
    {
        $correo = new MailController();
        echo $correo->enviarCorreo('lopezrafa@gmail.com', 'Nombre Remitente', 'lopezrafa@gmail.com', 'Nombre Destinatario', 'Asunto del correo', 'Este es el contenido del mensaje.');
    }
    public function postContacto()
    {
        //        $this->correo();
        $this->enviarmail();
        echo '<script>alert("Su ticket fue creado con éxito con el número ' . $this->ok . '");';
        echo 'window.location.href = "/contacto";</script>';
    }
    private function enviarmail()
    {
        $para = "lopezrafa@gmail.com";
        $asunto = "Asunto del correo";
        $mensaje = "Este es el contenido del mensaje.";
        // Puedes agregar encabezados adicionales si es necesario
        $headers = "From: lopezrafa@gmail.com\r\n";
        $headers .= "Reply-To: remitente@example.com\r\n";
        $headers .= "X-Mailer: PHP/" . phpversion();
        // Envía el correo
        mail($para, $asunto, $mensaje, $headers);
        echo "Correo enviado con éxito.";
    }



    function sendemail($mail_username, $mail_userpassword, $mail_setFromEmail, $mail_setFromName, $mail_addAddress, $txt_message, $mail_subject, $template)
    {
        require 'PHPMailer/PHPMailerAutoload.php';
        $mail = new PHPMailer;
        $mail->isSMTP();                            // Establecer el correo electrónico para utilizar SMTP
        $mail->Host = 'smtp.gmail.com';             // Especificar el servidor de correo a utilizar 
        $mail->SMTPAuth = true;                     // Habilitar la autenticacion con SMTP
        $mail->Username = $mail_username;          // Correo electronico saliente ejemplo: tucorreo@gmail.com
        $mail->Password = $mail_userpassword;         // Tu contraseña de gmail
        $mail->SMTPSecure = 'tls';                  // Habilitar encriptacion, `ssl` es aceptada
        $mail->Port = 587;                          // Puerto TCP  para conectarse 
        $mail->setFrom($mail_setFromEmail, $mail_setFromName); //Introduzca la dirección de la que debe aparecer el correo electrónico. Puede utilizar cualquier dirección que el servidor SMTP acepte como válida. El segundo parámetro opcional para esta función es el nombre que se mostrará como el remitente en lugar de la dirección de correo electrónico en sí.
        $mail->addReplyTo($mail_setFromEmail, $mail_setFromName); //Introduzca la dirección de la que debe responder. El segundo parámetro opcional para esta función es el nombre que se mostrará para responder
        $mail->addAddress($mail_addAddress);   // Agregar quien recibe el e-mail enviado
        $message = file_get_contents($template);
        $message = str_replace('{{first_name}}', $mail_setFromName, $message);
        $message = str_replace('{{message}}', $txt_message, $message);
        $message = str_replace('{{customer_email}}', $mail_setFromEmail, $message);
        $mail->isHTML(true);  // Establecer el formato de correo electrónico en HTML

        $mail->Subject = $mail_subject;
        $mail->msgHTML($message);
        if (!$mail->send()) {
            echo '<p style="color:red">No se pudo enviar el mensaje..';
            echo 'Error de correo: ' . $mail->ErrorInfo;
            echo "</p>";
        } else {
            echo '<p style="color:green">Tu mensaje ha sido enviado!</p>';
        }
    }
}
